unit uMain;

interface

uses
  CheckLst,Classes,Controls,ComCtrls,ExtCtrls,Forms,StdCtrls,SysUtils,Messages,Windows,
  uConst,uKoule;

type
  TMainForm = class(TForm)
    LE_Architecture: TLabeledEdit;
    LE_CPUcount: TLabeledEdit;
    LE_ActCPUmask: TLabeledEdit;
    Button: TButton;
    StatusBar: TStatusBar;
    Timer: TTimer;
    ChLB_UseCPU: TCheckListBox;
    procedure FormCreate(Sender: TObject);
    procedure ButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure ChLB_UseCPUClickCheck(Sender: TObject);
  private
    { Private declarations }
    CalcThread: TCalcThread;
    ActiveCPUMask: Cardinal;
  public
    { Public declarations }
  end;

  TBitArray = Cardinal;

  TCPUItem = class(TObject)
  public
    ActCPUMaskBit: Byte;
  end;


var MainForm: TMainForm;

implementation
{$R *.dfm}

function SetBit(BitArray: TBitArray; Bit: Byte): TBitArray;
begin
  Result:=BitArray or (1 shl Bit);
end;

function GetBit(BitArray: TBitArray; Bit: Byte): Boolean;
begin
  Result:=(BitArray and (1 shl Bit))<>0;
end;

function RstBit(BitArray: TBitArray; Bit: Byte): TBitArray;
begin
  Result:=BitArray and ($FF-(1 shl Bit));
end;



procedure TMainForm.FormCreate(Sender: TObject);
var SystemInfo: TSystemInfo; Count: integer; CPUItem: TCPUItem;
begin
  GetSystemInfo(SystemInfo);

  case SystemInfo.wProcessorArchitecture of
    PROCESSOR_ARCHITECTURE_INTEL: LE_Architecture.Text:='INTEL';
    PROCESSOR_ARCHITECTURE_MIPS: LE_Architecture.Text:='MIPS';
    PROCESSOR_ARCHITECTURE_ALPHA: LE_Architecture.Text:='ALPHA';
    PROCESSOR_ARCHITECTURE_PPC: LE_Architecture.Text:='PPC';
    PROCESSOR_ARCHITECTURE_SHX: LE_Architecture.Text:='SHX';
    PROCESSOR_ARCHITECTURE_ARM: LE_Architecture.Text:='ARM';
    PROCESSOR_ARCHITECTURE_IA64: LE_Architecture.Text:='IA64';
    PROCESSOR_ARCHITECTURE_ALPHA64: LE_Architecture.Text:='ALPHA64';
    PROCESSOR_ARCHITECTURE_MSIL: LE_Architecture.Text:='MSIL';
    PROCESSOR_ARCHITECTURE_AMD64: LE_Architecture.Text:='AMD64';
    PROCESSOR_ARCHITECTURE_IA32_ON_WIN64: LE_Architecture.Text:='IA32_ON_WIN64';
  else
    // PROCESSOR_ARCHITECTURE_UNKNOWN
    LE_Architecture.Text:='unknown';
  end;

  LE_CPUcount.Text:=(IntToStr(SystemInfo.dwNumberOfProcessors));

  ActiveCPUMask:=SystemInfo.dwActiveProcessorMask;
  LE_ActCPUmask.Text:=(IntToStr(ActiveCPUMask));

  ChLB_UseCPU.Clear;

  for Count:=0 to 31 do
    if GetBit(SystemInfo.dwActiveProcessorMask,Count) = True then
      begin
        CPUItem:=TCPUItem.Create;
        CPUItem.ActCPUMaskBit:=Count;
        ChLB_UseCPU.AddItem(Format('CPU %d',[Count+1]),CPUItem);
        ChLB_UseCPU.Checked[Count]:=True;
      end;

  CalcThread:=TCalcThread.Create;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
var TMP_Count: integer;
begin
  CalcThread.Terminate;

  with ChLB_UseCPU do
    for TMP_Count:=0 to Items.Count-1 do Items.Objects[TMP_Count].Free;
end;


procedure TMainForm.ButtonClick(Sender: TObject);
begin
  if CalcThread.Suspended then
    begin
      Button.Caption:='Zastavit vpoet';
      CalcThread.Resume;
      ChLB_UseCPU.Enabled:=False;
      Timer.Enabled:=True;
    end
  else
    begin
      Button.Caption:='Spustit vpoet';
      CalcThread.Suspend;
      ChLB_UseCPU.Enabled:=True;
      Timer.Enabled:=False;
    end;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
begin
  StatusBar.Panels[0].Text:=IntToStr(CalcThread.FCelkemKouli);
end;

procedure TMainForm.ChLB_UseCPUClickCheck(Sender: TObject);
begin
  with TCheckListBox(Sender) do
    if Checked[ItemIndex] then
      ActiveCPUMask:=SetBit(ActiveCPUMask,TCPUItem(Items.Objects[ItemIndex]).ActCPUMaskBit)
    else
      ActiveCPUMask:=RstBit(ActiveCPUMask,TCPUItem(Items.Objects[ItemIndex]).ActCPUMaskBit);

  if ActiveCPUMask<>0 then
    begin
      Button.Enabled:=True;
      SetThreadAffinityMask(CalcThread.Handle,ActiveCPUMask);
      LE_ActCPUmask.Text:=IntToStr(ActiveCPUMask);
    end
      else Button.Enabled:=False;
end;

end.
