unit uKoule;

interface
uses
  Classes,Forms,IniFiles,Messages,SysUtils,Windows;

type
  TCalcThread=class(TThread)
  public
    { Private declarations }
    FCelkemKouli: int64;
    constructor Create();
    destructor Destroy; override;
  published
   { Published declarations }
    procedure ShowDialog;
  protected
    { Protected declarations }
    procedure Execute; override;
  end;


implementation

function CP_Testuj(CelkemKouli: int64): boolean;
var Vrstva: integer; TmpKouli: int64;
begin
  TmpKouli:=0;
  Vrstva:=1;  { zanm od zhora - vrchn koule }

  repeat
    TmpKouli:=TmpKouli+Sqr(Vrstva);
    Inc(Vrstva);
  until TmpKouli>=CelkemKouli;

  if TmpKouli=CelkemKouli then Result:=True else Result:=False;
end;

function TP_KouliVeVrstve(Strana: int64): int64;
begin
  Result:=0;
  while Strana>0 do
    begin
      Inc(Result,Strana);
      Dec(Strana);
    end;
end;

function TP_Testuj(CelkemKouli: int64): boolean;
var Vrstva: integer; TmpKouli: int64;
begin
  TmpKouli:=0;
  Vrstva:=1;  { zanm od zhora - vrchn koule }

  repeat
    TmpKouli:=TmpKouli+TP_KouliVeVrstve(Vrstva);
    Inc(Vrstva);
  until TmpKouli>=CelkemKouli;
  if TmpKouli=CelkemKouli then Result:=True else Result:=False;
end;


constructor TCalcThread.Create();
var Tmp: string;
begin
  inherited Create(True);
  Priority:=tpLower;
  FreeOnTerminate:=True;

  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'work.ini') do
  try
    Tmp:=ReadString('Progress','Count','2');     { spolecne minimum, jednu kouli neuvazujeme }
    FCelkemKouli:=StrToInt64(Tmp);
  finally
    Free;
  end;
end;

Destructor TCalcThread.Destroy;
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'work.ini') do
  try
    WriteString('Progress','Count',IntToStr(FCelkemKouli));
    { spolecne minimum, jednu kouli neuvazujeme }
  finally
    Free;
  end;

  inherited Destroy;
end;               

procedure TCalcThread.ShowDialog;
begin
  Windows.MessageBox(Application.Handle,PChar('Mme een! :-)'),'Podvej...',MB_OK);
end;

procedure TCalcThread.Execute;
begin
  while not (CP_Testuj(FCelkemKouli) and TP_Testuj(FCelkemKouli) and Terminated) do
    Inc(FCelkemKouli);
  Synchronize(ShowDialog);
end;

end.
