#include <windows.h>
#include <stdio.h>

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
char szClassName[] = "TApiForm";

char szAboutText[] = "Copyright (C) 2003 Milan Cizek. All rights reseved.";

HANDLE hThread = NULL;
DWORD WINAPI ThreadFunc(LPVOID NotUsed);

HWND hLabel = NULL;
    
UINT_PTR Timer;  // timer ID
VOID CALLBACK TimerProc(HWND hwnd,UINT uMsg,UINT_PTR idEvent,DWORD dwTime);

long int unsigned CelkemKouli = 1;

bool CP_Testuj(long int unsigned CelkemKouli);
long int unsigned TP_KouliVeVrstve(long int unsigned Strana);
bool TP_Testuj(long int unsigned CelkemKouli);



int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance,
                   LPSTR lpszArgument, int nFunsterStil)
{
    HWND hwnd;               /* This is the handle for our window */
    MSG messages;            /* Here messages to the application are saved */
    WNDCLASSEX wincl;        /* Data structure for the windowclass */

    /* The Window structure */
    wincl.hInstance = hThisInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
    wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
    wincl.cbSize = sizeof (WNDCLASSEX);

    /* Use default icon and mouse-pointer */
    wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL;                 /* No menu */
    wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
    wincl.cbWndExtra = 0;                      /* structure or the window instance */
    /* Use Windows's default color as the background of the window */
    wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

    /* Register the window class, and if it fails quit the program */
    if (!RegisterClassEx (&wincl)) return 0;

    /* The class is registered, let's create the program*/
    hwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "Dlov koule",      /* Title Text */
           WS_EX_OVERLAPPEDWINDOW, /* default window */
           (GetSystemMetrics(SM_CXFULLSCREEN)-200)/2,       /* Windows decides the position */
           (GetSystemMetrics(SM_CYFULLSCREEN)-120)/2,       /* where the window ends up on the screen */
           200,                 /* The programs width */
           70,                  /* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           NULL,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

    AppendMenu(GetSystemMenu(hwnd,false),MF_SEPARATOR,0,"");
    AppendMenu(GetSystemMenu(hwnd,false),MF_STRING,WM_USER+200,"O progr&amu ...");

    hLabel = CreateWindow("Static","inicializace ...",WS_VISIBLE|WS_CHILD|SS_CENTER,
               20,15,160,13,hwnd,0,hThisInstance,NULL);

    /* Create Font Handle */
    HFONT hFont = 0;
    hFont = CreateFont(-11,0,0,0,400,0,0,0,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,
              CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,
              "MS Sans Serif");

    /* Change fonts */
    if (hFont!=0) SendMessage(hLabel,WM_SETFONT,(WPARAM)hFont,0);
    

    /* Make the window visible on the screen */
    ShowWindow (hwnd,nFunsterStil);

    /* Run the message loop. It will run until GetMessage() returns 0 */
    while (GetMessage (&messages, NULL, 0, 0))
    {
        /* Translate virtual-key messages into character messages */
        TranslateMessage(&messages);
        /* Send message to WindowProcedure */
        DispatchMessage(&messages);
    }

    /* The program return-value is 0 - The value that PostQuitMessage() gave */
    return messages.wParam;
}


/*  This function is called by the Windows function DispatchMessage()  */

LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)                  /* handle the messages */
    {
        case WM_CREATE:
          { DWORD dwThreadId = 0;
            hThread = CreateThread(NULL,0,ThreadFunc,NULL,0,&dwThreadId);
            SetThreadPriority(hThread,THREAD_PRIORITY_LOWEST);
            Timer = SetTimer(0,1,2000,&TimerProc);
            break;
          }
        case WM_DESTROY:
          { KillTimer(0,Timer);
            TerminateThread(hThread,0);
            CloseHandle(hThread); 
            PostQuitMessage(0);       /* send a WM_QUIT to the message queue */
            break;
          }
        case WM_SYSCOMMAND:
          { if (wParam==WM_USER+200) 
            MessageBox(hwnd,szAboutText,"O programu",MB_OK|MB_ICONINFORMATION);
          }
        default:                      /* for messages that we don't deal with */
            return DefWindowProc (hwnd, message, wParam, lParam);
    }

    return 0;
}


bool CP_Testuj(long int unsigned CelkemKouli)
{
  int Vrstva = 1;  // zanm od zhora - vrchn koule
  long int unsigned Result,TmpKouli = 0;

  do { TmpKouli+=Vrstva^2;
       Vrstva++;
     }
  while (TmpKouli<=CelkemKouli);
  
  if (TmpKouli==CelkemKouli) Result=true; else Result=false;

  return Result;
}

long int unsigned TP_KouliVeVrstve(long int unsigned Strana)
{
  long int unsigned Result;
  while ((--Strana)>0) Result+=Strana;
  return Result;
}

bool TP_Testuj(long int unsigned CelkemKouli)
{
  int Vrstva = 1;  // zanm od zhora - vrchn koule
  long int unsigned Result,TmpKouli = 0;

  do { TmpKouli+=TP_KouliVeVrstve(Vrstva);
       Vrstva++;
     }
  while (TmpKouli<=CelkemKouli);

  if (TmpKouli==CelkemKouli) Result=true; else Result=false;

  return Result;
}

DWORD WINAPI ThreadFunc(LPVOID NotUsed)
{
  while (!CP_Testuj(CelkemKouli) && !TP_Testuj(CelkemKouli))
    CelkemKouli++;

  char buffer[64]; 
  lltoa(CelkemKouli,buffer,10);
  SetWindowText(hLabel,strcat("Mme een !!! :-) - ",buffer));
}

VOID CALLBACK TimerProc(HWND hwnd,UINT uMsg,UINT_PTR idEvent,DWORD dwTime)
{
  char buffer[64]; 
  lltoa(CelkemKouli,buffer,10);
  SetWindowText(hLabel,buffer);
}


void SaveState()
{
  FILE *file;
  if ((file = fopen("delkoule.state","w"))!=NULL)
       { fwrite(&CelkemKouli,sizeof(CelkemKouli),1,file);
         fclose(file);
       }
}

void LoadState()
{
  FILE *file;
  if ((file = fopen("delkoule.state","r"))!=NULL)
       { fread(&CelkemKouli,1,sizeof(CelkemKouli),file);
         fclose(file);
       }
}
