unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Forms, Dialogs, StdCtrls, Controls, IniFiles,
  ExtCtrls;

type
  TMainForm = class(TForm)
    Button: TButton;
    L_Objem: TLabel;
    Timer: TTimer;
    L_PopisObj: TLabel;
    procedure ButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TCalcThread=class(TThread)
  public
    { Private declarations }
    FCelkemKouli: int64;
  published
   { Published declarations }
    procedure ShowDialog;
  protected
    { Protected declarations }
    procedure Execute; override;
  end;

  
var MainForm: TMainForm; CalcThread: TCalcThread;

implementation

{$R *.dfm}

function CP_Testuj(CelkemKouli: int64): boolean;
var Vrstva: integer; TmpKouli: int64;
begin
  TmpKouli:=0;
  Vrstva:=1;  { zanm od zhora - vrchn koule }

  repeat
    TmpKouli:=TmpKouli+Sqr(Vrstva);
    Inc(Vrstva);
  until TmpKouli>=CelkemKouli;
  if TmpKouli=CelkemKouli then Result:=True else Result:=False;
end;

function TP_KouliVeVrstve(Strana: int64): int64;
begin
  Result:=0;
  while Strana>0 do
    begin
      Inc(Result,Strana);
      Dec(Strana);
    end;
end;

function TP_Testuj(CelkemKouli: int64): boolean;
var Vrstva: integer; TmpKouli: int64;
begin
  TmpKouli:=0;
  Vrstva:=1;  { zanm od zhora - vrchn koule }

  repeat
    TmpKouli:=TmpKouli+TP_KouliVeVrstve(Vrstva);
    Inc(Vrstva);
  until TmpKouli>=CelkemKouli;
  if TmpKouli=CelkemKouli then Result:=True else Result:=False;
end;


procedure TCalcThread.ShowDialog;
begin
  ShowMessage('Mme een !!! :-)');
end;

procedure TCalcThread.Execute;
begin
  while not (CP_Testuj(FCelkemKouli) and TP_Testuj(FCelkemKouli) and Terminated) do
    Inc(FCelkemKouli);
  Synchronize(ShowDialog);
end;

procedure TMainForm.ButtonClick(Sender: TObject);
var Tmp: string;
begin
  Button.Enabled:=False;
  CalcThread.Resume;
  Timer.Enabled:=True;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  CalcThread:=TCalcThread.Create(True);
  CalcThread.Priority:=tpLower;
  CalcThread.FreeOnTerminate:=True;

  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'work.ini') do
  try
    Tmp:=ReadString('Progress','Count','2');     { spolecne minimum, jednu kouli neuvazujeme }
    CalcThread.FCelkemKouli:=StrToInt64(Tmp);
  finally
    Free;
  end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'work.ini') do
  try
    WriteString('Progress','Count',IntToStr(CalcThread.FCelkemKouli));
    { spolecne minimum, jednu kouli neuvazujeme }
  finally
    Free;
  end;

  CalcThread.Terminate;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
begin
  L_Objem.Caption:=IntToStr(CalcThread.FCelkemKouli);
end;

end.
