unit uMain;

interface

uses
  Buttons,Clipbrd,ComCtrls,Controls,Classes,ExtCtrls,Forms,Graphics,Menus,
  Messages,StdCtrls,Windows;

type
  TMainForm = class(TForm)
    Panel: TPanel;
    Image: TImage;
    StatusBar: TStatusBar;
    B_Start: TButton;
    ListBox: TListBox;
    L_Reseni: TLabel;
    PopupMenu: TPopupMenu;
    MI_CopySelected: TMenuItem;
    procedure B_StartClick(Sender: TObject);
    procedure MI_CopySelectedClick(Sender: TObject);
    procedure PopupMenuPopup(Sender: TObject);
  end;

var MainForm: TMainForm;

implementation
uses uDomecek;

{$R *.dfm}

const CLRF = #13#10;

procedure TMainForm.B_StartClick(Sender: TObject);
begin
  TButton(Sender).Enabled:=False;
  ListBox.Items.Clear;
  TDomecek.Create;
end;

procedure TMainForm.PopupMenuPopup(Sender: TObject);
begin
  MI_CopySelected.Enabled:=ListBox.SelCount>0;
end;

procedure TMainForm.MI_CopySelectedClick(Sender: TObject);
var IndexCount: integer; Text: string;
begin
  for IndexCount:=0 to ListBox.Items.Count-1 do
    if ListBox.Selected[IndexCount] then
      Text:=Text+ListBox.Items[IndexCount]+CLRF;

  Clipboard.AsText:=Text;
end;

end.
