unit uDomecek;

interface
uses Classes,Messages,SysUtils,Windows;

type
  TStavRelace = (rTrue,rFalse,rProhibited);

  TDomecek = class(TThread)
  private
    Kombinace: string;
    procedure NastavRelaci(Vrchol1,Vrchol2: Char; StavRelace: TStavRelace);
    procedure InitDomeckovychRelaci;
    function IsDomecekComplete: boolean;
    procedure ComputeDomecek(Kombinace: string);
    procedure AddToList;
    procedure OnComplete(Sender: TObject);
  protected
    procedure Execute; override;
  public
    constructor Create;
  end;


implementation
uses uMain;

var Relace: array['A'..'E','A'..'E'] of TStavRelace;


procedure TDomecek.NastavRelaci(Vrchol1,Vrchol2: Char; StavRelace: TStavRelace);
begin
  Relace[Vrchol1,Vrchol2]:=StavRelace;
  Relace[Vrchol2,Vrchol1]:=StavRelace;
end;

procedure TDomecek.InitDomeckovychRelaci;
var Vrchol: Char;
begin
  FillChar(Relace,SizeOf(Relace),rFalse);

  // vyadme spojnice sama se sebou
  for Vrchol:='A' to 'E' do
    NastavRelaci(Vrchol,Vrchol,rProhibited);

  // nastavme vjimky (body kter se nepropojuj)
  NastavRelaci('A','C',rProhibited);
  NastavRelaci('A','D',rProhibited);
end;

function TDomecek.IsDomecekComplete: boolean;
var Count_1,Count_2: Char;
begin
  Result:=True;

  for Count_1:='A' to 'E' do
    for Count_2:='A' to 'E' do
      if Relace[Count_1,Count_2]=rFalse then
        begin
          Result:=False;
          Exit;
        end;
end;


procedure TDomecek.ComputeDomecek(Kombinace: string);
var DalsiBod: Char; Count: integer;
begin
  if Length(Kombinace)<9 then
    for DalsiBod:='A' to 'E' do
      ComputeDomecek(Kombinace+DalsiBod)
  else
    begin
      InitDomeckovychRelaci;
      for Count:=1 to 8 do
        if (Relace[Kombinace[Count],Kombinace[Count+1]]=rFalse) then
          NastavRelaci(Kombinace[Count],Kombinace[Count+1],rTrue);

      if IsDomecekComplete then
        begin
          Self.Kombinace:=Kombinace;
          Synchronize(AddToList);
        end;
    end;
end;

procedure TDomecek.AddToList;
begin
  MainForm.ListBox.Items.Add(Kombinace);
end;

procedure TDomecek.OnComplete;
begin
  with MainForm do
    begin
      StatusBar.Panels[0].Text:=Format('Poet nalezench een: %d',[ListBox.Items.Count]);
      B_Start.Enabled:=True;
    end;
end;

procedure TDomecek.Execute;
var StartBod: Char;
begin
  InitDomeckovychRelaci;
  for StartBod:='A' to 'E' do ComputeDomecek(StartBod);
end;

constructor TDomecek.Create;
begin
  inherited Create(True);
  Priority:=tpLower;
  FreeOnTerminate:=True;
  OnTerminate:=OnComplete;
  Resume;
end;

end.
