unit uMain;

interface

uses
  Classes, ComCtrls, Controls, ExtCtrls, Forms, Messages, ShellAPI, StdCtrls,
  SysUtils, Windows, dialogs;

type
  TMainForm = class(TForm)
    DateTimePicker: TDateTimePicker;
    Button: TButton;
    ShutdownTimer: TTimer;
    MinimizeTimer: TTimer;
    ComboBox: TComboBox;
    procedure ButtonClick(Sender: TObject);
    procedure ShutdownTimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MinimizeTimerTimer(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    procedure InitTrayIcon;
    function ShutDownNT(AFlag: Cardinal): boolean;
  public
    { Public declarations }
    procedure WndProc(var MyMessage: TMessage); override;
  end;

var
  MainForm: TMainForm;

implementation
var MyNotifyStruct: TNotifyIconData;

{$R *.dfm}
{$R WindowsXP.res}

procedure TMainForm.WndProc(var MyMessage: TMessage);
begin
  with MyMessage do
    if (Msg = WM_USER+100) and (lParam=WM_LBUTTONDBLCLK) then
      begin
        Shell_NotifyIcon(NIM_DELETE,@MyNotifyStruct);
        Visible:=True;
      end
        else inherited WndProc(MyMessage);
end;

procedure TMainForm.InitTrayIcon;
begin
  with MyNotifyStruct do
  begin
    cbSize:=SizeOf(MyNotifyStruct);
    Wnd:=MainForm.Handle;
    uID:=0;
    uFlags:=NIF_ICON or NIF_MESSAGE or NIF_TIP;
    uCallbackMessage:=WM_USER+100;
    hIcon:=Application.Icon.Handle;
    szTip:='Shutdown NT/XP';
  end;
end;

function TMainForm.ShutDownNT(AFlag: Cardinal): boolean;
const SE_SHUTDOWN_NAME = 'SeShutdownPrivilege';
var FHandleToken: THandle; FTokenPrivileges: TOKEN_PRIVILEGES; FTmpCardinal: cardinal;
begin
  Result:=false;

  if not OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_PRIVILEGES or TOKEN_QUERY,FHandleToken) then
    Exit;

  if not LookupPrivilegeValue(nil,SE_SHUTDOWN_NAME,FTokenPrivileges.Privileges[0].Luid) then
    Exit;

  FTokenPrivileges.PrivilegeCount:=1;
  FTokenPrivileges.Privileges[0].Attributes:=SE_PRIVILEGE_ENABLED;
  FTmpCardinal:=0;

  AdjustTokenPrivileges(FHandleToken,False,FTokenPrivileges,0,nil,FTmpCardinal);
  if GetLastError()<>ERROR_SUCCESS then Exit;

  case ComboBox.ItemIndex of
    0: SetSystemPowerState(False,True);  // Hibernace
    1: ExitWindowsEx(AFlag,0);  // Shutdown
  end;

  Result:=True;
end;

procedure TMainForm.ButtonClick(Sender: TObject);
begin
  if ShutDownTimer.Enabled then
    begin
      Button.Caption:='Spustit';
      DateTimePicker.Enabled:=True;
      ComboBox.Enabled:=True;
      ShutdownTimer.Enabled:=False;
      MinimizeTimer.Enabled:=False;
    end
  else
    begin
      Button.Caption:='Zastavit';
      DateTimePicker.Enabled:=False;
      ComboBox.Enabled:=False;
      ShutdownTimer.Enabled:=True;
      MinimizeTimer.Enabled:=True;
    end;
end;

procedure TMainForm.ShutdownTimerTimer(Sender: TObject);
begin
  if TimeToStr(DateTimePicker.Time)=TimeToStr(Time) then
    begin
      ShutDownNT(EWX_POWEROFF or EWX_FORCE);
      Close;
    end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  InitTrayIcon;
  DateTimePicker.Time:=Time+EncodeTime(1,0,0,0);
  ComboBox.ItemIndex:=0;
end;

procedure TMainForm.MinimizeTimerTimer(Sender: TObject);
begin
  if MainForm.Visible and ShutdownTimer.Enabled then
    begin
      Shell_NotifyIcon(NIM_ADD,@MyNotifyStruct);
      Visible:=False;
      MinimizeTimer.Enabled:=False;
    end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  if ShutdownTimer.Enabled then MinimizeTimer.Enabled:=True;
end;

end.
