program SysColors;

uses
  Classes, Forms, SysUtils, Windows;

const
  TotalColors = 30;
  Colors: array[0..TotalColors-1] of integer = (COLOR_SCROLLBAR,
                                                COLOR_BACKGROUND,
                                                COLOR_ACTIVECAPTION,
                                                COLOR_INACTIVECAPTION,
                                                COLOR_MENU,
                                                COLOR_WINDOW,
                                                COLOR_WINDOWFRAME,
                                                COLOR_MENUTEXT,
                                                COLOR_WINDOWTEXT,
                                                COLOR_CAPTIONTEXT,
                                                COLOR_ACTIVEBORDER,
                                                COLOR_INACTIVEBORDER,
                                                COLOR_APPWORKSPACE,
                                                COLOR_HIGHLIGHT,
                                                COLOR_HIGHLIGHTTEXT,
                                                COLOR_BTNFACE,
                                                COLOR_BTNSHADOW,
                                                COLOR_GRAYTEXT,
                                                COLOR_BTNTEXT,
                                                COLOR_INACTIVECAPTIONTEXT,
                                                COLOR_BTNHIGHLIGHT,
                                                COLOR_3DDKSHADOW,
                                                COLOR_3DLIGHT,
                                                COLOR_INFOTEXT,
                                                COLOR_INFOBK,
                                                COLOR_HOTLIGHT,
                                                COLOR_GRADIENTACTIVECAPTION,
                                                COLOR_GRADIENTINACTIVECAPTION,
                                                COLOR_MENUHILIGHT,
                                                COLOR_MENUBAR);

var
  ActColors: array[0..29] of COLORREF;
  CfgFile: string;
  ToBeSet: integer;
  NewColor: COLORREF;
  Count: integer;

begin
  CfgFile:=ExtractFilePath(Application.ExeName)+'SysColors.cfg';

  if FindCmdLineSwitch('save',['-','/'],True) then
    for Count:=Low(Colors) to High(Colors) do
      begin
        ActColors[Count]:=GetSysColor(Colors[Count]);

        with TMemoryStream.Create do
        try
          WriteBuffer(ActColors,SizeOf(ActColors));
          SaveToFile(CfgFile);
        finally
          Free;
        end;
      end;

  if FindCmdLineSwitch('load',['-','/'],True) then
    begin
        with TMemoryStream.Create do
        try
          LoadFromFile(CfgFile);
          Read(ActColors,SizeOf(ActColors));
        finally
          Free;
        end;

      for Count:=Low(Colors) to High(Colors) do
        begin
          ToBeSet:=Colors[Count];
          NewColor:=ActColors[Count];
          SetSysColors(1,ToBeSet,NewColor)
        end;
    end;
end.
