program RichEditFix;

uses Windows,Messages,RichEdit;
{$R *.res}

var
  MainWindow: HWND; MainWndClass: TWndClass; Msg: TMsg;


procedure SendREMessage(Wnd: HWND);
var ClassName: array[0..255] of Char; TMP: DWORD;
begin
  GetClassName(Wnd,ClassName,SizeOf(ClassName));

  if Pos('RichEdit',ClassName) > 0 then
    begin
      TMP:=SendMessage(Wnd,EM_GETLANGOPTIONS,0,0) and not IMF_AUTOFONT;
      SendMessage(Wnd,EM_SETLANGOPTIONS,0,TMP);
    end;
end;


function EnumChildProc(Wnd: HWND; LParam: LongInt): Boolean; stdcall;
begin
  SendREMessage(Wnd);
  EnumChildWindows(Wnd,@EnumChildProc,0);
  Result:=True;
end;

function EnumWindowsProc(Wnd: HWND; LParam: LongInt): Boolean; stdcall;
begin
  EnumChildWindows(Wnd,@EnumChildProc,0);
  Result:=True;
end;



function MainWndProc(Window: HWND; Msg: UINT; WParam: WParam; LParam: LParam): LRESULT; stdcall;
begin
  Result:=0;
  case Msg of
    WM_DESTROY:
      PostQuitMessage(0);
  end;
end;

function CreateMainWindow: boolean;
begin
  Result:=False;
  with MainWndClass do
  begin
    Style:=CS_DBLCLKS;
    lpfnWndProc:=@MainWndProc;
    cbClsExtra:=0;
    cbWndExtra:=0;
    lpszMenuName:=nil;
    lpszClassName:='TApplication';
    hbrBackground:=0;
    hIcon:=0;
    hCursor:=0;
    hInstance:=MainInstance;
  end;

  if RegisterClass(MainWndClass)<>0 then
    begin
      MainWindow:=CreateWindow(MainWndClass.lpszClassName,  // pointer to registered class name
                               'MilanC RichEdit Fix',       // pointer to window name
                               WS_DISABLED,                 // window style
                               0,                           // horizontal position of window
                               0,                           // vertical position of window
                               0,                           // window width
                               0,                           // window height
                               0,                           // handle to parent or owner window
                               0,                           // handle to menu or child-window identifier
                               HInstance,                   // handle to application instance
                               nil);                        // pointer to window-creation data
      Result:=True;
    end;
end;

procedure TimerCallBack(Handle: HWND; uMsg,idEvent: UINT; dwTime: DWORD); stdcall;
begin
  EnumWindows(@EnumWindowsProc,0);
end;

begin
  if CreateMainWindow then
    begin
      SetPriorityClass(GetCurrentProcess,IDLE_PRIORITY_CLASS);
      SetThreadPriority(GetCurrentThread,THREAD_PRIORITY_LOWEST);

      SetTimer(MainWindow,0,2000,@TimerCallBack);

      while GetMessage(Msg,0,0,0) do
        begin
          TranslateMessage(Msg);
          DispatchMessage(Msg);
        end;

      KillTimer(MainWindow,0);
      DestroyWindow(MainWindow);
    end;
end.

