program AppsOnLAN;

{$APPTYPE CONSOLE}

uses
  Classes,
  Registry,
  SysUtils,
  Windows;

var Computers: TStringList; Count: integer;

procedure EnumNetResources(List: TStrings);
  procedure EnumFunc(NetResource: PNetResource);
  var
    Buffer: array[0..16384 div SizeOf(TNetResource)] of TNetResource;
    Enum: THandle; Count,BufferSize: DWORD; Counter: integer;
  begin
    if WNetOpenEnum(RESOURCE_GLOBALNET,RESOURCETYPE_ANY,0,NetResource,Enum) = NO_ERROR then
    try
      Count:=$FFFFFFFF;
      BufferSize:=SizeOf(Buffer);
      while WNetEnumResource(Enum,Count,@Buffer,BufferSize)=NO_ERROR do
        for Counter:=0 to Count-1 do
          begin
            if Buffer[Counter].dwDisplayType=RESOURCEDISPLAYTYPE_SERVER then
              List.Add(Copy(Buffer[Counter].lpRemoteName,3,length(Buffer[Counter].lpRemoteName)));
            if (Buffer[Counter].dwUsage and RESOURCEUSAGE_CONTAINER) > 0 then
              EnumFunc(@Buffer[Counter]);
          end;
    finally
      WNetCloseEnum(Enum);
    end;
  end;

begin
  EnumFunc(nil);
end;

procedure CheckInstallApps(Computer: string; AppSubstr: string);
var KeyNames: TStringList; Count: integer; DisplayName: string;
begin
  with TRegistry.Create do
  try
    RootKey:=HKEY_LOCAL_MACHINE;
    if RegistryConnect('\\'+Computer) then
      if OpenKey('Software\Microsoft\Windows\CurrentVersion\Uninstall',False) then
        begin
          KeyNames:=TStringList.Create;
          GetKeyNames(KeyNames);
          CloseKey;

          for Count:=0 to KeyNames.Count-1 do
            begin
              OpenKey('Software\Microsoft\Windows\CurrentVersion\Uninstall\'+KeyNames[Count],False);
              if ValueExists('DisplayName') then
                begin
                  DisplayName:=ReadString('DisplayName');
                  if Length(DisplayName)=0 then Break;

                  if AppSubstr='*' then
                    begin
                      Writeln(' -> '+DisplayName)
                    end
                  else
                    if Pos(LowerCase(AppSubstr),LowerCase(DisplayName))>0 then
                      Writeln(' -> '+DisplayName);
                end;
              CloseKey;
            end;

          KeyNames.Free;
        end;
  finally

    Free;
  end;
end;


begin
  if ParamCount=0 then
    begin
      Writeln('Command line parameters: AppsOnLAN.exe [ * | AppName]');
      Halt;
    end;

  Computers:=TStringList.Create;
  EnumNetResources(Computers);

  for Count:=0 to Computers.Count-1 do
    begin
      Writeln('COMPUTER: '+Computers[Count]);
      CheckInstallApps(Computers[Count],ParamStr(1));
      Writeln('');
    end;

  Computers.Free
end.


