unit uObject;

interface
uses Windows;

type
  TMyObject = class(TObject)
  private
    { Private declarations }
    FEntry: array of record Name: string[20]; Value: string[50]; end;
    FLastIndex: integer;
  public
    { Public declarations }
    FSegLength: integer;
    procedure AddEntry(Name,Value: string);
    function DeleteEntry(Pos: integer): boolean;
    function GetValue(Pos: integer): string;
    function ReplaceValue(Pos: integer; Value: string): boolean;
    function GetPosByName(Name: string): integer;
    constructor Create;
    destructor Destroy; override;
  end;
  
implementation

procedure TMyObject.AddEntry(Name,Value: string);
begin
  Inc(FLastIndex,1);
  if FLastIndex=Length(FEntry) then
    SetLength(FEntry,Length(FEntry)+FSegLength);  { alokuj segment }

  FEntry[FLastIndex].Name:=Name;
  FEntry[FLastIndex].Value:=Value;
end;

function TMyObject.DeleteEntry(Pos: integer): boolean;
begin
  Result:=True;
  if (Pos>=Low(FEntry)) and (Pos<=FLastIndex) then
    begin
      FEntry[Pos]:=FEntry[FLastIndex];

      { poze pro lep pehled pi krokovn, jinak zbyten }
      FEntry[FLastIndex].Name:=''; FEntry[FLastIndex].Value:='';

      Dec(FLastIndex,1);
      if (Length(FEntry)-FSegLength)>FLastIndex then  { pokud nen segment vyuit, uvoln se }
        SetLength(FEntry,Length(FEntry)-FSegLength);
    end
      else Result:=False;
end;

function TMyObject.GetValue(Pos: integer): string;
begin
  if (Pos>=Low(FEntry)) and (Pos<=FLastIndex) then Result:=FEntry[Pos].Value;
end;

function TMyObject.ReplaceValue(Pos: integer; Value: string): boolean;
begin
  Result:=True;
  if (Pos>=Low(FEntry)) and (Pos<=FLastIndex) then FEntry[Pos].Value:=Value
    else Result:=False;
end;

function TMyObject.GetPosByName(Name: string): integer;
var Counter: integer;
begin
  Result:=-1;
  for Counter:=Low(FEntry) to FLastIndex do
    if FEntry[Counter].Name=Name then
      begin
        Result:=Counter; Break;
      end;
end;

constructor TMyObject.Create;
begin
  SetLength(FEntry,0);
  FLastIndex:=-1;
  FSegLength:=100;  { vchoz hodnota }
end;

destructor TMyObject.Destroy;
begin
  SetLength(FEntry,0);
  FLastIndex:=-1;
end;

end.
