unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TMainForm = class(TForm)
    MemoLog: TMemo;
    ButtonTest: TButton;
    procedure ButtonTestClick(Sender: TObject);
  private
    { Private declarations }
    function GetTime: string;
  public
    { Public declarations }
  end;

var MainForm: TMainForm;

implementation
{$R *.dfm}

uses uObject;

const Zaznamu: integer = 100000;
var Frequency,Overhead,Start,Stop: int64;

function TMainForm.GetTime: string;
var ElapsedTime: Extended;
begin
  ElapsedTime:=(Stop-Start-Overhead)/Frequency;
  if ElapsedTime<0.1 then Result:=FloatToStrF(ElapsedTime*1000,ffNumber,7,6)+' s' else
    if ElapsedTime<1 then Result:=FloatToStrF(ElapsedTime*100,ffNumber,7,4)+' ms' else
      Result:=FloatToStrF(ElapsedTime,ffNumber,7,2)+' s';
end;

procedure TMainForm.ButtonTestClick(Sender: TObject);
var Counter,Pos: integer;
begin
  ButtonTest.Enabled:=False;
  MemoLog.Lines.Clear;

  with TMyObject.Create do
  try
    FSegLength:=500;  { po kolika bude alokace probhat? }

    { njak ty data pro test }
    QueryPerformanceCounter(Start);
    for Counter:=1 to Zaznamu-1 do
      AddEntry('Jmno'+IntToStr(Counter),'Pjmen'+IntToStr(Counter));
    QueryPerformanceCounter(Stop);
    MemoLog.Lines.Add('Naplnn daji ('+IntToStr(Zaznamu)+' poloek): '+GetTime);

    { njak ty data pro test }
    QueryPerformanceCounter(Start);
    AddEntry('Jmno'+IntToStr(Zaznamu),'Pjmen'+IntToStr(Zaznamu));
    QueryPerformanceCounter(Stop);
    MemoLog.Lines.Add('Pidn poslednho zznamu: '+GetTime);

    { vyhledn prvnho }
    QueryPerformanceCounter(Start);
    Pos:=GetPosByName('Jmno1');
    QueryPerformanceCounter(Stop);
    if Pos<>-1 then MemoLog.Lines.Add('Hodnota je "'+GetValue(Pos)+'": '+GetTime)
      else MemoLog.Lines.Add('Zznam nenalezen za: '+GetTime);

    { vyhledn poslednho }
    QueryPerformanceCounter(Start);
    Pos:=GetPosByName('Jmno'+IntToStr(Zaznamu));
    QueryPerformanceCounter(Stop);
    if Pos<>-1 then MemoLog.Lines.Add('Hodnota je "'+GetValue(Pos)+'": '+GetTime)
      else MemoLog.Lines.Add('Zznam nenalezen: '+GetTime);

    { doba porovnn }
    QueryPerformanceCounter(Start);
    GetPosByName('');
    QueryPerformanceCounter(Stop);
    MemoLog.Lines.Add('Vechny zznamy porovnny za: '+GetTime);

    { doba replace poslednho }
    QueryPerformanceCounter(Start);
    ReplaceValue(Zaznamu-1,'Nov hodnota');
    QueryPerformanceCounter(Stop);
    MemoLog.Lines.Add('Hodnota nahrazena za: '+GetTime);

    { doba odstrann poslednho }
    QueryPerformanceCounter(Start);
    DeleteEntry(Zaznamu-1);
    QueryPerformanceCounter(Stop);
    MemoLog.Lines.Add('Zznam odstraen za: '+GetTime);
  finally
    Free;
  end;

  ButtonTest.Enabled:=True;
end;

initialization
  if not QueryPerformanceFrequency(Frequency) then
    ShowMessage('Nepodailo se zskat frekvenci performance counteru!');
  QueryPerformanceCounter(Start);
  QueryPerformanceCounter(Stop);
  Overhead:=Stop-Start;

end.
